package com.company.model;

import com.company.exceptions.InvalidDataException;

public class Lecture {
    private Subject subject;

    public Lecture(Subject subject) {
        this.setSubject(subject);
    }


    public Subject getSubject() {
        return this.subject;
    }

    public void setSubject(Subject subject) {
        if (subject != null) {
            this.subject = subject;
        } else {
            String msg = "Lecture: subject = NULL";
            throw new InvalidDataException(msg);
        }
    }

    public boolean isEqualTo(Lecture obj) {
        if (this.subject.isEqualTo(obj.subject)) {
            return true;
        }
        return false;
    }

    public boolean isEqualTo(Subject obj) {
        if (this.subject.isEqualTo(obj)) {
            return true;
        }
        return false;
    }
    public boolean isEqualTo(String initials) {
        if (this.subject.isEqualTo(initials)) {
            return true;
        }
        return false;
    }
}
